<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
ob_start(); // Prevent "headers already sent" issues

/* -------------------------- DATABASE CONNECTION --------------------------- */
$sName = "localhost";
$uName = "investme_test";
$pass = "Pharma#123";
$db_name = "investme_test";

try {
    $conn = new PDO("mysql:host=$sName;dbname=$db_name;charset=utf8mb4", $uName, $pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    // Debug: echo "✅ DB Connected Successfully<br>";
} catch (PDOException $e) {
    die("Connection failed: " . htmlspecialchars($e->getMessage()));
}

/* -------------------------------------------------------
   🔐 OPTIONAL TOOL: Generate bcrypt hash for a password
   Example: login.php?makehash=123456
------------------------------------------------------- */
if (isset($_GET['makehash'])) {
    $pwd = $_GET['makehash'];
    $hash = password_hash($pwd, PASSWORD_DEFAULT);
    echo "<pre>Generated hash for '$pwd':\n\n$hash</pre>";
    exit;
}

/* -------------------------- LOGIN PROCESS --------------------------- */
$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $uname = trim($_POST['uname'] ?? '');
    $password = trim($_POST['pass'] ?? '');
    $role = trim($_POST['role'] ?? '');

    if (empty($uname)) {
        $error = "Username is required.";
    } elseif (empty($password)) {
        $error = "Password is required.";
    } elseif (empty($role)) {
        $error = "Please select a role.";
    } else {

        // Map roles to tables and redirects
        switch ($role) {
            case '1':
                $table = "admin";
                $idField = "admin_id";
                $redirect = "admin/index.php";
                $roleName = "Admin";
                break;

            case '2':
                $table = "teachers";
                $idField = "teacher_id";
                $redirect = "Teacher/index.php";
                $roleName = "Teacher";
                break;

            case '3':
                $table = "students";
                $idField = "student_id";
                $redirect = "Student/index.php";
                $roleName = "Student";
                break;

            case '4':
                $table = "registrar_office";
                $idField = "r_user_id";
                $redirect = "RegistrarOffice/index.php";
                $roleName = "Registrar Office";
                break;

            default:
                $error = "Invalid role selection.";
                $table = "";
        }

        if (empty($error)) {
            $stmt = $conn->prepare("SELECT * FROM $table WHERE username = ?");
            $stmt->execute([$uname]);

            if ($stmt->rowCount() === 1) {
                $user = $stmt->fetch(PDO::FETCH_ASSOC);
                $dbHash = $user['password'];

                if (password_verify($password, $dbHash)) {
                    // ✅ Successful login
                    $_SESSION['role'] = $roleName;
                    $_SESSION['user'] = [
                        'id' => $user[$idField],
                        'fname' => $user['fname'] ?? '',
                        'lname' => $user['lname'] ?? '',
                        'username' => $user['username']
                    ];

                    // ✅ Redirect safely
                    header("Location: $redirect");
                    ob_end_flush();
                    exit;
                } else {
                    $error = "Incorrect username or password.";
                }
            } else {
                $error = "Incorrect username or password.";
            }
        }
    }
}
?>

<!-- -------------------------- LOGIN FORM --------------------------- -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Y School</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="css/style.css">
    <link rel="icon" href="logo.png">
</head>
<body class="body-login">
    <div class="black-fill"><br><br>
        <div class="d-flex justify-content-center align-items-center flex-column">

            <form class="login" method="post" action="">
                <div class="text-center mb-3">
                    <img src="logo.png" width="100" alt="Logo">
                </div>
                <h3 class="text-center mb-3">LOGIN</h3>

                <?php if (!empty($error)): ?>
                    <div class="alert alert-danger text-center" role="alert">
                        <?= htmlspecialchars($error) ?>
                    </div>
                <?php endif; ?>

                <div class="mb-3">
                    <label class="form-label">Username</label>
                    <input type="text" class="form-control" name="uname" placeholder="Enter username" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Password</label>
                    <input type="password" class="form-control" name="pass" placeholder="Enter password" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Login As</label>
                    <select class="form-control" name="role" required>
                        <option value="">Select Role</option>
                        <option value="1">Admin</option>
                        <option value="2">Teacher</option>
                        <option value="3">Student</option>
                        <option value="4">Registrar Office</option>
                    </select>
                </div>

                <button type="submit" class="btn btn-primary w-100">Login</button>
                <a href="index.php" class="d-block text-center mt-2 text-decoration-none">Home</a>
            </form>

            <br><br>
            <div class="text-center text-light small">
                Copyright &copy; <?= date("Y") ?> Y School. All rights reserved.
            </div>
        </div>
    </div>
</body>
</html>
