<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ---------- DATABASE CONNECTION ----------
$host = "localhost";
$dbname = "investme_test";
$user = "investme_test";
$pass = "Pharma#123";

try {
    $conn = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("<strong>Database Connection Failed:</strong> " . htmlspecialchars($e->getMessage()));
}

// ---------- ADD ADMIN ----------
$message = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $fname = trim($_POST["fname"] ?? "");
    $lname = trim($_POST["lname"] ?? "");
    $username = trim($_POST["username"] ?? "");
    $password = trim($_POST["password"] ?? "");

    if ($fname === "" || $lname === "" || $username === "" || $password === "") {
        $message = "<div class='alert alert-danger text-center'>All fields are required.</div>";
    } else {
        // Check if username already exists
        $stmt = $conn->prepare("SELECT username FROM admin WHERE username = ?");
        $stmt->execute([$username]);

        if ($stmt->rowCount() > 0) {
            $message = "<div class='alert alert-warning text-center'>Username already exists!</div>";
        } else {
            // Hash the password
            $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

            // Insert new admin
            $insert = $conn->prepare("INSERT INTO admin (username, password, fname, lname) VALUES (?, ?, ?, ?)");
            $done = $insert->execute([$username, $hashedPassword, $fname, $lname]);

            if ($done) {
                $message = "<div class='alert alert-success text-center'>✅ Admin added successfully!</div>";
            } else {
                $message = "<div class='alert alert-danger text-center'>Failed to add admin. Please try again.</div>";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card shadow-lg border-0 rounded-3">
                    <div class="card-body">
                        <h3 class="text-center mb-4">Add Admin</h3>
                        <?= $message ?>
                        <form method="POST" action="">
                            <div class="mb-3">
                                <label class="form-label">First Name</label>
                                <input type="text" class="form-control" name="fname" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Last Name</label>
                                <input type="text" class="form-control" name="lname" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Username</label>
                                <input type="text" class="form-control" name="username" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Password</label>
                                <input type="password" class="form-control" name="password" required>
                            </div>

                            <button type="submit" class="btn btn-primary w-100">Add Admin</button>
                            <a href="login.php" class="d-block text-center mt-3 text-decoration-none">Back to Login</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
